function fadeInSection(scene, selection, movingOffset, direction, idleTicks) {
    let link = scene.world.showIndependentSection(selection, direction);
    scene.world.moveSection(link, movingOffset, 0); // 0 to instantly move
    scene.idle(idleTicks);
    scene.world.hideIndependentSection(link, direction);
    scene.idle(idleTicks);
}

const TICK_LENGTH = 20;
const IDLE_TICK_LENGTH = TICK_LENGTH * 3;

Ponder.registry((event) => {
    event.create('endrem:cryptic_eye').scene('cryptic_eye', 'How to obtain the Cryptic Eye.', (scene, util) =>{
        
        const pos = [4, 1.5, 4];
        const start = [0, 0, 0];
        const end = [7, 7, 7];
        //scene.particles.simple(TICK_LENGTH*999, "rain", start).density(10).area(end);

        // Grass Plate
        scene.showBasePlate();
        scene.world.setBlocks([0, 0, 0, 4, 0, 4], "minecraft:oak_planks", false);
        scene.world.showSection([0, 0, 0, 4, 0, 4], Facing.UP);
        scene.world.setBlocks([2, 1, 4, 4, 2, 4], "minecraft:bookshelf", false);
        scene.world.showSection([2, 1, 4, 4, 2, 4], Facing.UP);
        scene.world.setBlocks([1, 1, 4], 'minecraft:bookshelf');
        scene.world.showSection([1, 1, 4], Facing.UP);
        scene.world.setBlocks([4, 1, 3], 'minecraft:anvil');
        scene.world.showSection([4, 1, 3], Facing.UP);

        // Wandering Trader
        const centerBlockPos = util.grid.at(1, 0, 2);
        const centerTop = util.vector.topOf(centerBlockPos);
        const wanTraderEntity = scene.world.createEntity("wandering_trader", centerTop);

        const centerBlockPosWan = util.grid.at(1, 1, 2)
        const centerTopWan = util.vector.topOf(centerBlockPosWan);
        
        // Villager
        const centerBlockPos1 = util.grid.at(3, 0, 2);
        const centerTop1 = util.vector.topOf(centerBlockPos1);
        const villagerEntity = scene.world.createEntity("villager", centerTop1);
        const centerBlockPosVil = util.grid.at(3, 1, 2)
        const centerTopVil = util.vector.topOf(centerBlockPosVil);

        // change lookAt
        scene.world.modifyEntity(wanTraderEntity, (e) => {
            e.lookAt("feet", centerTop1);
        })
        scene.world.modifyEntity(villagerEntity, (e) => {
            e.lookAt("feet", centerTop);
        })
        scene.idle(40)

        // Toss Cage
        const cage = scene.world.createItemEntity(centerTopVil, util.vector.of(-0.15, 0.1, 0), Item.of('supplementaries:cage', '{BlockEntityTag:{MobHolder:{EntityData:{id:"minecraft:frog"}}}}'));
        scene.text(90, "Trade a Frog in a Cage to a Wandering Villager for a Dull Eye", [1, 2, 4]).placeNearTarget();
        scene.idle(30)
        scene.world.removeEntity(cage)
        scene.idle(20)

        // Toss Dull Eye
        const dull_eye = scene.world.createItemEntity(centerTopWan, util.vector.of(0.15, 0.1, 0), 'cashmere:dull_eye');
        scene.idle(30)
        scene.world.removeEntity(dull_eye)
        scene.idle(20)

        // Remove Wandering Trader + Enchanting Table
        scene.world.removeEntity(wanTraderEntity)
        scene.idle(20)
        scene.world.setBlocks([2, 1, 2], "minecraft:enchanting_table");
        scene.world.showSection([2, 1, 2], Facing.DOWN);
        scene.idle(20)
        scene.text(80, "With 30 levels, right-click the Dull Eye on an Enchanting Table", [2.5, 2.5, 2.5]).placeNearTarget();


        const dull_eye2 = scene.world.createItemEntity(centerTopVil, util.vector.of(-0.08, 0.3, 0), 'cashmere:dull_eye');
        scene.idle(20)
        scene.world.removeEntity(dull_eye2)
        const centerBlockTable = util.grid.at(2, 1, 2)
        const centerBlockTableTop = util.vector.topOf(centerBlockTable)
        const cryptic_eye = scene.world.createItemEntity(centerBlockTableTop, util.vector.of(0, 0.3, 0), Item.of('endrem:cryptic_eye', '{NoGravity:1}'))
        scene.idle(60)
    })

    event.create('endrem:exotic_eye').scene('exotic_eye', 'How to obtain the Exotic Eye.', (scene, util) =>{

        // Grass Plate
        scene.showBasePlate();
        scene.world.setBlocks([0, 0, 0, 4, 0, 4], "minecraft:grass_block", false);
        scene.world.showSection([0, 0, 0, 4, 0, 4], Facing.UP);
        scene.world.setBlocks([2, 1, 4, 2, 2, 4], 'minecraft:iron_bars', false);
        scene.world.setBlocks([1, 1, 4, 1, 2, 4], "minecraft:spruce_planks", false);
        scene.world.setBlocks([3, 1, 4, 3, 2, 4], "minecraft:spruce_planks", false);
        scene.world.setBlocks([0, 3, 4, 4, 3, 4], "minecraft:spruce_slab", false);
        scene.world.showSection([0, 1, 4, 4, 3, 4], Facing.UP);

        // Allay
        const allayBlockPos = util.grid.at(3, 0, 2);
        const allayCenterTop = util.vector.topOf(allayBlockPos);
        const allayEntity = scene.world.createEntity("allay", allayCenterTop);

        // Villager
        const centerBlockPos1 = util.grid.at(1, 0, 2);
        const centerTop1 = util.vector.topOf(centerBlockPos1);
        const villagerEntity = scene.world.createEntity("villager", centerTop1);
        const centerBlockPosVil = util.grid.at(1, 1, 2)
        const centerTopVil = util.vector.topOf(centerBlockPosVil);


        // change lookAt
        scene.world.modifyEntity(allayEntity, (e) => {
            e.lookAt("feet", centerTop1);
        })
        scene.world.modifyEntity(villagerEntity, (e) => {
            e.lookAt("feet", allayCenterTop);
        })

        scene.text(60, "Talk to the Allay to find out what they want", [2.5, 3, 2]);
        scene.showControls(60, [3, 2, 2], "down").withItem("fire_coral")
        scene.idle(60)

        // Toss Dull Eye
        const fire_coral = scene.world.createItemEntity(centerTopVil, util.vector.of(0.15, 0.1, 0), 'fire_coral');
        scene.idle(30)
        scene.world.removeEntity(fire_coral)
        scene.world.modifyEntity(allayEntity, (e) => {
            e.setItemInHand("MAIN_HAND", 'fire_coral');
        });
        scene.text(90, "If you give them the correct type of Coral, it will give the Exotic Eye in return", [2.5, 3, 2]);
        scene.idle(90)
        scene.world.modifyEntity(allayEntity, (e) => {
            e.setItemInHand("MAIN_HAND", 'endrem:exotic_eye');
        });
        scene.idle(40)
        scene.world.modifyEntity(allayEntity, (e) => {
            e.setItemInHand("MAIN_HAND", 'air');
        });
        const eye = scene.world.createItemEntity(allayCenterTop, util.vector.of(-0.15, 0.1, 0), 'endrem:exotic_eye');


    })

    event.create('endrem:cold_eye').scene('cold_eye', 'How to obtain the Cold Eye.', 'kubejs:igloobasement', (scene, util) =>{
       /*
        // Base Plate
        scene.showBasePlate();
        scene.world.setBlocks([0, 0, 0, 4, 0, 4], "minecraft:snow_block", false);
        scene.world.showSection([0, 0, 0, 4, 0, 4], Facing.UP);
        scene.world.setBlocks([1, 1, 1, 3, 3, 4], "minecraft:snow_block", false);
        scene.world.setBlocks([2, 1, 1, 2, 2, 2], 'air', false);
        scene.world.setBlocks([0, 1, 2, 0, 3, 4], "minecraft:snow_block", false);
        scene.world.setBlocks([4, 1, 2, 4, 3, 4], "minecraft:snow_block", false);
        scene.world.setBlocks([1, 4, 2, 3, 4, 4], "minecraft:snow_block", false);
        scene.world.showSection([0, 1, 0, 4, 4, 4], Facing.UP);

        scene.text(60, "Find an Igloo in the Snowy Mountains", [2.5, 3, 2]);
        scene.idle(60)
        scene.world.hideSection([0, 0, 0, 4, 4, 4], Facing.UP)
        scene.idle(20)
        scene.world.setBlocks([0, 0, 0, 4, 4, 4], "air", false);
   

        scene.world.setBlocks([0, 0, 0, 4, 0, 4], "minecraft:stone_bricks", false);
        scene.world.setBlocks([0, 1, 4, 4, 3, 4], "minecraft:stone_bricks", false);
        scene.world.setBlocks([1, 1, 4, 1, 2, 4], "air", false);
        scene.world.setBlocks([3, 1, 4, 3, 2, 4], "air", false);
        scene.world.setBlocks([4, 1, 1], 'water_cauldron', false);
        scene.world.setBlocks([4, 1, 2, 4, 1, 3], 'oak_planks', false);
        scene.world.setBlocks([4, 2, 3], 'brewing_stand', false);
        scene.idle(20)
        scene.world.showSection([0, 0, 0, 4, 4, 4], Facing.UP)
*/
        scene.rotateCameraY(-90)
        scene.showStructure();
        scene.idle(20)
        // ZVillager
        const centerBlockPos = util.grid.at(4, 0, 3);
        const centerTop = util.vector.topOf(centerBlockPos);
        
        const centerBlockPos1 = util.grid.at(6, 0, 3);
        const centerTop1 = util.vector.topOf(centerBlockPos1);
        const zVillagerEntity = scene.world.createEntity("zombie_villager", centerTop1);
        const centerBlockPosZVil = util.grid.at(6, 1, 3)
        const centerTopZVil = util.vector.topOf(centerBlockPosZVil);
        scene.world.modifyEntity(zVillagerEntity, (e) => {
            e.lookAt("feet", centerTop);
        })
        scene.idle(20)

        // Villager

        const villagerEntity = scene.world.createEntity("villager", centerTop);
        const centerBlockPosVil = util.grid.at(4, 1, 3)
        const centerTopVil = util.vector.topOf(centerBlockPosVil);

        // change lookAt
        scene.world.modifyEntity(villagerEntity, (e) => {
            e.lookAt("feet", centerTop1);
        })

        scene.text(60, "Cure an Igloo's Zombie Villager back into a Villager", centerTop1);
        scene.idle(60)

        // Toss items
        const potion = scene.world.createItemEntity(centerTopVil, util.vector.of(0.15, 0.2, 0), Item.of('minecraft:splash_potion', '{Potion:"minecraft:weakness"}'));
        scene.idle(10)
        scene.world.removeEntity(potion)
        scene.idle(20)
        const apple = scene.world.createItemEntity(centerTopVil, util.vector.of(0.15, 0.2, 0), 'minecraft:golden_apple');
        scene.idle(10)
        scene.world.removeEntity(apple)
        scene.idle(60)

        scene.world.removeEntity(zVillagerEntity)
        const VillagerEntity2 = scene.world.createEntity("villager", centerTop1);
        scene.world.modifyEntity(VillagerEntity2, (e) => {
            e.lookAt("feet", centerTop);
        })
        scene.text(60, "Once healed, it will sell you something special!", centerTop1);
        scene.idle(60)
        scene.idle(20)
        scene.world.modifyEntity(VillagerEntity2, (e) => {
            e.setItemInHand("MAIN_HAND", 'endrem:cold_eye');
        });
        scene.idle(20)
        const candy = scene.world.createItemEntity(centerTopVil, util.vector.of(0.15, 0.2, 0), '16x supplementaries:candy');
        scene.idle(20)
        scene.world.removeEntity(candy)
        scene.world.modifyEntity(VillagerEntity2, (e) => {
            e.setItemInHand("MAIN_HAND", 'air');
        });
        scene.idle(10)
        const cold_eye = scene.world.createItemEntity(centerTopZVil, util.vector.of(-0.12, 0.2, 0), 'endrem:cold_eye');

    })

    event.create('endrem:evil_eye').scene('evil_eye', 'How to obtain the Evil Eye.', 'kubejs:fortress', (scene, util) =>{
       /*
        // Base Plate
        scene.showBasePlate();
         
        scene.world.setBlocks([0, 0, 0, 4, 1, 4], "minecraft:nether_bricks", false);
        scene.world.setBlocks([0, 2, 0, 4, 2, 4], "minecraft:nether_brick_fence", false);
        scene.world.setBlocks([1, 1, 1, 3, 2, 3], "air", false);
        scene.world.setBlocks([1, 1, 0, 3, 2, 0], "air", false);
        scene.world.setBlocks([2, 1, 2], 'spawner', false);

        scene.world.modifyTileNBT([2, 1, 2], (nbt) => {
                
            nbt.SpawnData = {entity: {id: "minecraft:blaze"}}
        });
        scene.world.showSection([0, 0, 0, 4, 3, 4], Facing.UP);*/
        scene.showStructure();
        scene.text(60, "Find a Nether Fortress with a Blaze Spawner", [0, 3, 2]);
        scene.idle(60)

        // Villager
        const centerBlockPos1 = util.grid.at(3, 0, 4);
        const centerTop1 = util.vector.topOf(centerBlockPos1);
        const villagerEntity = scene.world.createEntity("villager", centerTop1);
        const centerBlockPosVil = util.grid.at(3, 1, 4)
        const centerTopVil = util.vector.topOf(centerBlockPosVil);

        scene.text(60, "Use a Blazing Geode on the Spawner", [0, 3, 2]);
        scene.idle(60)

        scene.world.modifyEntity(villagerEntity, (e) => {
            e.setItemInHand("MAIN_HAND", 'cashmere:blazing_geode');
        });
        scene.idle(20)
        const blazing_geode = scene.world.createItemEntity(centerTopVil, util.vector.of(0, 0.3, -0.08), 'cashmere:blazing_geode');
        scene.world.modifyEntity(villagerEntity, (e) => {
            e.setItemInHand("MAIN_HAND", 'air');
        });
        scene.idle(20)
        scene.world.removeEntity(blazing_geode)
        scene.world.replaceBlocks([3, 1, 3], 'minecraft:air', true);

        // Blaze Guardian
        const centerBlockPos = util.grid.at(3, 0, 3);
        const centerTop = util.vector.topOf(centerBlockPos);
        const guardianEntity = scene.world.createEntity("adventurez:blaze_guardian", centerTop);
        const centerBlockPosGuard = util.grid.at(3, 1, 3)
        const centerTopGuard = util.vector.topOf(centerBlockPosGuard);

        scene.world.modifyEntity(guardianEntity, (e) => {
            e.lookAt("feet", centerTop1);
        })
        scene.text(60, "Defeat the Blaze Guardian to claim your prize!", [0, 3, 2]);
        scene.idle(60)

        scene.world.removeEntity(guardianEntity);
        const evil_eye = scene.world.createItemEntity(centerTopGuard, util.vector.of(0, 0.3, 0), 'endrem:evil_eye');

    })

    event.create('endrem:nether_eye').scene('nether_eye', 'How to obtain the Nether Eye.', 'kubejs:nether_eye', (scene, util) => {
        scene.rotateCameraY(90)
        scene.showStructure();

        const centerBlockPos = util.grid.at(4, 0, 5);
        const centerTop = util.vector.topOf(centerBlockPos);
        scene.text(90, "Build a Soul Pedestal structure in the Nether", [4, 3, 2]);
        scene.idle(90)

        // Villager
        const centerBlockPos1 = util.grid.at(5, 0, 5);
        const centerTop1 = util.vector.topOf(centerBlockPos1);
        const villagerEntity = scene.world.createEntity("villager", centerTop1);
        const centerBlockPosVil = util.grid.at(5, 1, 5)
        const centerTopVil = util.vector.topOf(centerBlockPosVil);
        scene.world.modifyEntity(villagerEntity, (e) => {
            e.lookAt("feet", centerTop);
        })
        scene.text(90, "Use a Soul Crystal Shard containing an Iron Golem on the Pedestal", [4, 3, 2]);
        scene.idle(90)
        scene.world.modifyEntity(villagerEntity, (e) => {
            e.setItemInHand("MAIN_HAND", 'spirit:soul_crystal_shard');
        });
        scene.idle(20)
        const item = scene.world.createItemEntity(centerTopVil, util.vector.of(-0.08, 0.3, 0), 'spirit:soul_crystal_shard');
        scene.world.modifyEntity(villagerEntity, (e) => {
            e.setItemInHand("MAIN_HAND", 'air');
        });
        scene.idle(20)
        scene.world.removeEntity(item)
        scene.text(60, "Summon and defeat the Blackstone Golem", [4, 3, 2]);
        scene.idle(60)

        // Blaze Guardian

        const guardianEntity = scene.world.createEntity("adventurez:stone_golem", centerTop);
        const centerBlockPosGuard = util.grid.at(4, 1, 5)
        const centerTopGuard = util.vector.topOf(centerBlockPosGuard);

        scene.world.modifyEntity(guardianEntity, (e) => {
            e.lookAt("feet", centerTop1);
        })
        scene.text(60, "Upon killing it, you will be rewarded with a fancy Nether Eye!", [4, 3, 2]);
        scene.idle(60)
        scene.world.removeEntity(guardianEntity);
        const nether_eye = scene.world.createItemEntity(centerTopGuard, util.vector.of(0, 0.3, 0), 'endrem:nether_eye');

    })


    });